#pragma rtGlobals=1		// Use modern global access method.
#pragma version=3.1

// ******** MPR 3 Band *******

Function MPR3BandReset()
	MPR3BandSetupDesign()
	SetAxis/A/Z bottom			// in case user set a manual X axis range
	Execute "m3b_compute(\"\")"
End

Function ButtonMPR3Band(ctrlName) : ButtonControl
	String ctrlName

	DoWindow/F WMMPR3BandDesign
	if( V_Flag==0 )
		MPR3BandSetupDesign()
	endif
End

Function MPR3BandSetupDesign()

	SetApplyButtonTitle(0)

	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	
	Variable brejBpass=NumVarOrDefault("m3b_rp",2)
	Variable nt=NumVarOrDefault("m3b_n",41)
	Variable b1end=NumVarOrDefault("m3b_b1e",0.1)
	Variable b2start=NumVarOrDefault("m3b_b2s",0.12)
	Variable b2end=NumVarOrDefault("m3b_b2e",0.28)
	Variable b3start=NumVarOrDefault("m3b_b3s",0.3)
	Variable b2weight=NumVarOrDefault("m3b_b2w",1)
 
	// Create the globals
	Variable/G m3b_rp=brejBpass
	Variable/G m3b_n=nt
	Variable/G m3b_b1e=b1end
	Variable/G m3b_b2s=b2start
	Variable/G m3b_b2e=b2end
	Variable/G m3b_b3s=b3start
	Variable/G m3b_b2w=b2weight

	// scale the saved normalized frequencies for the SetVariable controls
	Variable/G m3b_b1e_fs= b1end * fs
	Variable/G m3b_b2s_fs= b2start * fs
	Variable/G m3b_b2e_fs=b2end * fs
	Variable/G m3b_b3s_fs=b3start * fs

	SetDataFolder dfSav

	MPR3BandUpdate()
	CreateMPR3BandDesign()
	MPR3BandUpdate()			// set the control limits, too.
End

// update waves that show the MPR 3 Band design parameters
// This is called whenever any parameters change.
Function MPR3BandUpdate()

	NVAR fs= root:Packages:WM_IFDL:fs
	String dfSav= Set_IFDL_DataFolder()

	Variable brejBpass=NumVarOrDefault("m3b_rp",2)
	Variable nt=NumVarOrDefault("m3b_n",41)
	Variable b2weight=NumVarOrDefault("m3b_b2w",1)

	Variable b1endFs= NumVarOrDefault("m3b_b1e_fs",0.1 * fs)
	Variable b2startFs=NumVarOrDefault("m3b_b2s_fs",0.12 * fs)
	Variable b2endFs=NumVarOrDefault("m3b_b2e_fs",0.28 * fs)
	Variable b3startFs=NumVarOrDefault("m3b_b3s_fs",0.3 * fs)

	// Save the normalized frequencies in case the user changes sampling frequency
	Variable/G m3b_b1e= b1endFs/fs
	Variable/G m3b_b2s= b2startFs/fs
	Variable/G m3b_b2e=b2endFs/fs
	Variable/G m3b_b3s=b3startFs/fs

	Variable isLowPass= brejBpass == 1	// first band is passband if reject filter is selected
	
	// Passband and stop band response pair, linear response
	Make/O m3b_responseX = {0,b1endFs,NaN,b2startFs,b2endFs,NaN,b3startFs,fs*0.5}
	Make/O m3b_response  = {isLowPass,isLowPass,NaN,!isLowPass,!isLowPass,NaN,isLowPass,isLowPass}	// updated by DesiredFromActualResponse
	Variable eps= min(abs(b1EndFs - b2startFS),abs(b2endFs - b3startFs))/8
	DesiredFromActualResponse(m3b_response,"WMMPR3BandDesign",b1endFs,b2startFs,b2endFs,b3startFs,isLowPass,eps)
	
	// transition region waves
	Make/O          m3b_transitionX = {m3b_responseX[1],m3b_responseX[3],NaN,m3b_responseX[4],m3b_responseX[6]}
	Make/O/N=5 m3b_transitionPlus =  max(max(m3b_response[0],m3b_response[3]),m3b_response[6])
	m3b_transitionPlus[2]= NaN
	Make/O/N=5 m3b_transitionMinus = min(min(m3b_response[0],m3b_response[3]),m3b_response[6])
	m3b_transitionMinus[2]= NaN

	DoWindow WMMPR3BandDesign
	if( V_Flag == 1 ) // don't allow the end of the pass band to exceed the start of the stop band
		ControlInfo/W=WMMPR3BandDesign m3b_b1e
		Variable band1End= V_Value
		ControlInfo/W=WMMPR3BandDesign m3b_b2s
		Variable band2Start= V_Value
		
		ControlInfo/W=WMMPR3BandDesign m3b_b2e
		Variable band2End= V_Value
		ControlInfo/W=WMMPR3BandDesign m3b_b3s
		Variable band3Start= V_Value

		Variable df=  NiceNumber(fs/200)
		// don't let band 1 end after the start of band 2
		Variable end1Max= max(band1End,band2Start)
		end1Max= limit(end1Max,0,fs/2)
		SetVariable m3b_b1e,limits={0,end1Max,df},win=WMMPR3BandDesign
		
		// don't let band 2 start before the end of band 1
		Variable start2Min= min(band1End,band2Start)
		start2Min= limit(start2Min,0, fs/2)
		// or end after the end of band 2
		Variable start2Max = max(band2Start,band2End)
		start2Max= limit(start2Max,0, fs/2)
		SetVariable m3b_b2s,limits={start2Min,start2Max,df},win=WMMPR3BandDesign

		// don't let the end of band 2 start before the start of band 2
		Variable end2Min= min(band2Start,band2End)
		end2Min= limit(end2Min,0, fs/2)
		// or end after the start of band 3
		Variable end2Max = max(band2End,band3Start)
		end2Max= limit(end2Max,0, fs/2)
		SetVariable m3b_b2e,limits={end2Min,end2Max,df},win=WMMPR3BandDesign

		// don't let the start of band 3 start before the end of band 2
		Variable start3Min= min(band2End,band3Start)
		start3Min= limit(start3Min,0, fs/2)
		SetVariable m3b_b3s,limits={start3Min,fs/2,df},win=WMMPR3BandDesign

		ControlUpdate/A/W=WMMPR3BandDesign
	endif
	SetDataFolder dfSav
End

Function CreateMPR3BandDesign()

	if( DesignGraph("WMMPR3BandDesign","MPR 3 Band Design") )
		return 1	// already existed, don't reset the graph settings.
	endif

	NVAR fs= root:Packages:WM_IFDL:fs
	NVAR brejBpass= root:Packages:WM_IFDL:m3b_rp	// see PopupMenu m3b_lphp, below

	String typeList= "band reject;band pass"
	String popMenuValue= GetStrFromList(typeList, brejBpass, ";")
	Variable df= NiceNumber(fs/200)	// 1,2,5 increment for SetVariable controls

	String dfSav= Set_IFDL_DataFolder()
	AppendToGraph/L=responseLeft m3b_transitionPlus,m3b_transitionMinus vs m3b_transitionX
	AppendToGraph/L=responseLeft m3b_response vs m3b_responseX
	SetDataFolder dfSav

	ModifyGraph mode(m3b_transitionPlus)=7
	ModifyGraph lSize(m3b_transitionPlus)=0,lSize(m3b_transitionMinus)=0
	ModifyGraph rgb(m3b_transitionPlus)=(56797,56797,56797)
	ModifyGraph hbFill(m3b_transitionPlus)=2
	ModifyGraph toMode(m3b_transitionPlus)=1
	ModifyGraph lblPos(responseLeft)=60
	ModifyGraph freePos(responseLeft)={0,bottom}
	ModifyGraph margin(left)=67
	ModifyGraph minor(bottom)=1
	Label responseLeft "response (dB)"
	SetAxis/A/N=1 responseLeft
	ControlBar 82
	SetVariable m3b_b1e,pos={26,2},size={199,17},proc=MPR_m3b,title="End of First Band"
	SetVariable m3b_b1e,limits={0,fs/2,df},value= root:Packages:WM_IFDL:m3b_b1e_fs
	SetVariable m3b_b2s,pos={2,21},size={223,17},proc=MPR_m3b,title="Start of Second Band"
	SetVariable m3b_b2s,limits={0,fs/2,df},value= root:Packages:WM_IFDL:m3b_b2s_fs
	SetVariable m3b_b2e,pos={14,40},size={211,17},proc=MPR_m3b,title="End of Second Band"
	SetVariable m3b_b2e,limits={0,fs/2,df},value= root:Packages:WM_IFDL:m3b_b2e_fs
	SetVariable m3b_b3s,pos={12,59},size={213,17},proc=MPR_m3b,title="Start of Third Band"
	SetVariable m3b_b3s,limits={0,fs/2,df},value= root:Packages:WM_IFDL:m3b_b3s_fs
	PopupMenu m3b_rp,pos={302,1},size={166,19},proc=m3bTypePopup,title="Filter Type"
	PopupMenu m3b_rp,mode=brejBpass,popvalue=popMenuValue,value= #"\"band reject;band pass\""
	SetVariable m3b_b2w,pos={256,22},size={212,17},title="Second Band Weighting"
	SetVariable m3b_b2w,limits={0.001,Inf,0.5},value= root:Packages:WM_IFDL:m3b_b2w
	SetVariable m3b_n,pos={292,41},size={176,17},title="Number of Terms"
	SetVariable m3b_n,limits={5,9999,1},value= root:Packages:WM_IFDL:m3b_n
	CheckBox dbCheck,pos={239,61},size={110,15},proc=m3bCheck,title="dB Response",value=1
	Button m2bCompute,pos={359,61},size={109,16},proc=m3b_compute,title="Compute Filter"
	Textbox/N=m3bLegend/X=0.99/Y=34.30 ""
	m3bLegend()
	SetWindow WMMPR3BandDesign, hook=designHook
	return 0
end


Function m3bTypePopup(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum	// which item is currently selected (1-based)
	String popStr		// contents of current popup item as string

	NVAR rejBpass= root:Packages:WM_IFDL:m3b_rp
	rejBpass= popNum
	MPR3BandUpdate()
End


Function m3bCheck(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
 	
 	dBCheck(checked)
	MPR3BandUpdate()
	m3bLegend()
End

Function MPR_m3b(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName

	MPR3BandUpdate()
End

Function m3bLegend()
	DesignLegend("WMMPR3BandDesign","m3b","m3bLegend")
End

Proc m3b_compute(ctrlName) : ButtonControl
	String ctrlName

	Silent 1;PauseUpdate	 // MPR 3 Band...
	String dfSav= Set_IFDL_DataFolder()
	Variable brejBpass= m3b_rp
	Variable nt= m3b_n
	Variable b2weight= m3b_b2w
	Variable b1end= m3b_b1e
	Variable b2start= m3b_b2s
	Variable b2end= m3b_b2e
	Variable b3start= m3b_b3s
	SetDataFolder dfSav
	Variable fs = root:Packages:WM_IFDL:fs
	
	if( nt > 9999 )
		Abort "Too many filter terms. Max is 9999."
	endif 
	if( ChkFreq(b1end,b2start,b2end,b3start) )
		abort
	endif

	Set_IFDL_DataFolder()
	Variable isNotch=brejBpass==1
	String/G proposedFilterName="mpr3Band"
	String/G designTypeName="McClellan-Parks; three band"
	Variable/G designFlags=0x3
	Make/O bandInfo= {isNotch,0,b1end*fs,!isNotch,b2start*fs,b2end*fs,isNotch,b3start*fs,0.5*fs}

	String mpDes="des"
	String mpWt="wt"
	String mpGrid="grid"
	MPRMakeWaves(mpDes,mpWt,mpGrid,nt)	// makes them in the WM_IFDL folder.
	
	$mpDes=isNotch
	$mpDes(b2start,b2end)=isNotch==0
	$mpWt(b2start,b2end)=b2weight
	$mpGrid(b1end,b2start)=NaN
	$mpGrid(b2end,b3start)=NaN
	
	SetDataFolder dfSav
	Make/O/N=(nt) coefs
	MPKernel(mpDes,mpWt,mpGrid,"coefs",0)

	StdCoefsTreatmentNoShowResults(0x1e,1)

	DoWindow/F WMMPR3BandDesign
	CheckDisplayed/W=WMMPR3BandDesign root:Packages:WM_IFDL:coefsMag,root:Packages:WM_IFDL:coefsDbMag
	if( V_Flag == 0 )
		ControlInfo/W=WMMPR3BandDesign dbCheck
		Variable wantDB= V_value
		Append/L=responseLeft $responseName(wantDB,1)
		String traceName= responseName(wantDB,0)
		ModifyGraph rgb($traceName)=(0,0,65535)
		ReorderTraces m3b_response, {$traceName}	// put actual response under desired response
	endif
	AppendPassDetails("detailsLeft",root:Packages:WM_IFDL:magPassDetails)	// appends /L=detailsLeft
	MPR3BandUpdate()
	AutoApplyFilter()
	m3bLegend()
end
